<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'kasir'){
    header("Location: ../login.php");
    exit;
}

if(isset($_POST['kasir'], $_POST['tanggal'], $_POST['qty'], $_POST['bayar'])){

    $kasir = mysqli_real_escape_string($koneksi, $_POST['kasir']);
    $tanggal = mysqli_real_escape_string($koneksi, $_POST['tanggal']);
    $bayar = intval($_POST['bayar']);
    $total_harga = 0;
    $details = [];

    foreach($_POST['qty'] as $id_produk => $qty){
        $id_produk = intval($id_produk);
        $qty = intval($qty);
        if($qty > 0){
            $q = mysqli_query($koneksi, "SELECT * FROM produk WHERE id_produk=$id_produk");
            if(!$q) die("Query produk gagal: ".mysqli_error($koneksi));
            $p = mysqli_fetch_assoc($q);

            if($qty > $p['stok']){
                die("Stok produk {$p['nama_produk']} tidak cukup. Stok tersedia: {$p['stok']}");
            }

            $subtotal = $p['harga'] * $qty;
            $total_harga += $subtotal;

            $details[] = [
                'id_produk'=>$id_produk,
                'nama_produk'=>$p['nama_produk'],
                'harga'=>$p['harga'],
                'qty'=>$qty,
                'subtotal'=>$subtotal
            ];

            // Update stok
            $update = mysqli_query($koneksi,"UPDATE produk SET stok=stok-$qty WHERE id_produk=$id_produk");
            if(!$update) die("Gagal update stok: ".mysqli_error($koneksi));
        }
    }

    if(count($details) === 0){
        die("Tidak ada produk yang dipilih.");
    }

    $kembalian = $bayar - $total_harga;
    if($kembalian < 0){
        die("Uang bayar kurang dari total belanja!");
    }

    // Insert transaksi
    $insert_transaksi = mysqli_query($koneksi,
        "INSERT INTO transaksi (kasir, tanggal, total_harga, bayar, kembalian) 
        VALUES ('$kasir','$tanggal',$total_harga,$bayar,$kembalian)"
    );
    if(!$insert_transaksi) die("Gagal insert transaksi: ".mysqli_error($koneksi));
    $id_transaksi = mysqli_insert_id($koneksi);

    // Insert detail transaksi
    foreach($details as $d){
        $nama_produk = mysqli_real_escape_string($koneksi, $d['nama_produk']);
        $insert_detail = mysqli_query($koneksi,
            "INSERT INTO transaksi_detail 
            (id_transaksi,id_produk,nama_produk,harga,qty,subtotal)
            VALUES ($id_transaksi, {$d['id_produk']}, '$nama_produk', {$d['harga']}, {$d['qty']}, {$d['subtotal']})"
        );
        if(!$insert_detail) die("Gagal insert detail: ".mysqli_error($koneksi));
    }

    // Redirect ke struk
    header("Location: struk.php?id_transaksi=$id_transaksi");
    exit;
} else {
    die("Form tidak lengkap.");
}
?>
