<?php
session_start();
include "../koneksi.php";

// Hanya admin dan kasir yang boleh akses
if(!isset($_SESSION['id_user']) || !in_array($_SESSION['role'], ['admin','kasir'])){
    exit("Akses ditolak!");
}

// Ambil ID transaksi dari GET
$id_transaksi = intval($_GET['id_transaksi']);

// Ambil transaksi
$transaksi_q = mysqli_query($koneksi, "SELECT * FROM transaksi WHERE id_transaksi=$id_transaksi");
if(!$transaksi_q || mysqli_num_rows($transaksi_q) == 0){
    exit("Transaksi tidak ditemukan!");
}
$transaksi = mysqli_fetch_assoc($transaksi_q);

// Ambil detail transaksi
$details_q = mysqli_query($koneksi, "SELECT * FROM transaksi_detail WHERE id_transaksi=$id_transaksi");

// Ambil tanggal saja tanpa jam
$tanggal_only = date('Y-m-d', strtotime($transaksi['tanggal']));
?>

<div class="container-struk" style="font-family:'Segoe UI',sans-serif;">
<h3>Struk Transaksi</h3>
<p><strong>Kasir:</strong> <?= htmlspecialchars($transaksi['kasir']) ?></p>
<p><strong>Tanggal:</strong> <?= $tanggal_only ?></p>

<table border="1" cellpadding="5" cellspacing="0" style="width:100%;border-collapse:collapse;margin-top:10px;">
<tr>
<th>Produk</th>
<th>Qty</th>
<th>Harga</th>
<th>Subtotal</th>
</tr>
<?php while($d = mysqli_fetch_assoc($details_q)){ ?>
<tr>
<td><?= htmlspecialchars($d['nama_produk']) ?></td>
<td><?= $d['qty'] ?></td>
<td>Rp <?= number_format($d['harga'],0,',','.') ?></td>
<td>Rp <?= number_format($d['subtotal'],0,',','.') ?></td>
</tr>
<?php } ?>
<tr>
<td colspan="3"><strong>Total</strong></td>
<td>Rp <?= number_format($transaksi['total_harga'],0,',','.') ?></td>
</tr>
<tr>
<td colspan="3">Bayar</td>
<td>Rp <?= number_format($transaksi['bayar'],0,',','.') ?></td>
</tr>
<tr>
<td colspan="3">Kembalian</td>
<td>Rp <?= number_format($transaksi['kembalian'],0,',','.') ?></td>
</tr>
</table>
</div>
