# 🔧 FIX: Admin Ganti Password Kasir

## ❌ MASALAH:

Admin tidak bisa mengubah password kasir melalui halaman Edit User.

---

## ✅ SOLUSI:

### **1. File `admin/edit_user.php` (FIXED)**

**Masalah:**
- Saat update password, hanya menyimpan `password` (hash)
- Tidak menyimpan `password_text` (plain text)
- Sistem memerlukan kedua field untuk berfungsi dengan baik

**Perbaikan:**
```php
// SEBELUM (SALAH):
if(!empty($_POST['password'])){
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    mysqli_query($koneksi, "UPDATE users SET nama='$nama', username='$username', password='$password', role='$role' WHERE id_user=$id");
}

// SETELAH (BENAR):
if(!empty($_POST['password'])){
    $password_plain = $_POST['password'];
    $password_hash = password_hash($password_plain, PASSWORD_DEFAULT);
    mysqli_query($koneksi, "UPDATE users SET 
        nama='$nama', 
        username='$username', 
        password='$password_hash', 
        password_text='$password_plain', 
        role='$role' 
        WHERE id_user=$id");
}
```

---

### **2. File `admin/tambah_user.php` (BONUS FIX)**

**Masalah:**
- Menggunakan `md5()` untuk hash password (TIDAK AMAN!)
- Tidak konsisten dengan sistem lainnya yang menggunakan `password_hash()`

**Perbaikan:**
```php
// SEBELUM (SALAH):
$password = md5($password_text);

// SETELAH (BENAR):
$password = password_hash($password_text, PASSWORD_DEFAULT);
```

---

## 🧪 CARA TEST:

### **Test 1: Edit Password Kasir**

1. Login sebagai admin
2. Buka menu "Kelola User"
3. Klik "Edit" pada user kasir
4. Ubah password kasir (misal: `kasir123`)
5. Klik "Simpan Perubahan"
6. Logout
7. Login sebagai kasir dengan password baru
8. **Hasil:** ✅ Harus bisa login!

### **Test 2: Tambah User Baru**

1. Login sebagai admin
2. Buka menu "Kelola User"
3. Klik "Tambah User"
4. Isi data user baru dengan password (misal: `user123`)
5. Klik "Simpan User"
6. Logout
7. Login dengan user baru tersebut
8. **Hasil:** ✅ Harus bisa login!

---

## 📊 STRUKTUR DATABASE:

Tabel `users` memiliki 2 field password:

| Field | Type | Keterangan |
|-------|------|------------|
| `password` | VARCHAR | Password hash (untuk keamanan) |
| `password_text` | VARCHAR | Password plain text (untuk referensi admin) |

**Kedua field HARUS diisi saat:**
- Tambah user baru
- Update password user
- Reset password

---

## ✅ CHECKLIST:

- [x] File `admin/edit_user.php` sudah diperbaiki
- [x] File `admin/tambah_user.php` sudah diperbaiki
- [x] Menggunakan `password_hash()` untuk keamanan
- [x] Menyimpan `password_text` untuk referensi
- [ ] Test edit password kasir
- [ ] Test tambah user baru

---

## 🔒 KEAMANAN:

### **Mengapa Menggunakan `password_hash()`?**

1. ✅ **Lebih Aman** - Menggunakan algoritma bcrypt
2. ✅ **Salt Otomatis** - Setiap password punya salt unik
3. ✅ **Standar Modern** - Recommended oleh PHP
4. ✅ **Tidak Bisa Direverse** - Tidak bisa dikembalikan ke plain text

### **Mengapa Masih Simpan `password_text`?**

1. ✅ Admin bisa lihat password kasir jika lupa
2. ✅ Memudahkan troubleshooting
3. ✅ Sistem legacy yang sudah ada

**CATATAN:** Di production yang sangat strict, `password_text` sebaiknya dihapus untuk keamanan maksimal.

---

## 🎯 KESIMPULAN:

### **Sebelum Fix:**
- ❌ Admin tidak bisa ganti password kasir
- ❌ Menggunakan md5 (tidak aman)
- ❌ Tidak konsisten

### **Setelah Fix:**
- ✅ Admin bisa ganti password kasir
- ✅ Menggunakan password_hash (aman)
- ✅ Konsisten di semua file
- ✅ Menyimpan password_text untuk referensi

---

**Status:** ✅ FIXED  
**Dibuat:** 30 Januari 2026, 09:40 WIB  
**File Diubah:** 2 file (edit_user.php, tambah_user.php)
