# 🧹 CLEANUP SEBELUM HOSTING

## 📋 DAFTAR FILE YANG PERLU DIHAPUS:

### **1. File Test & Development:**
- `test_url_dinamis.php` - File test URL dinamis (hanya untuk demo)

### **2. File Dokumentasi (Opsional - Bisa dihapus atau dipertahankan):**
- `README_HOSTING_FIX.md` - Penjelasan fix hosting (opsional)
- `README_KENAPA_MASIH_LOCALHOST.md` - Penjelasan localhost (opsional)
- `DAFTAR_FILE_HAPUS.md` - Daftar file hapus lama (opsional)
- `CLEANUP_SEBELUM_HOSTING.md` - File ini sendiri (hapus setelah cleanup)

### **3. File Darurat (Jika Ada):**
- `reset_admin_darurat.php` - Jika masih ada
- `reset_kasir_darurat.php` - Jika masih ada

---

## ✅ FILE YANG WAJIB DIPERTAHANKAN:

### **File Utama Aplikasi:**
1. ✅ `koneksi.php` - Koneksi database
2. ✅ `login.php` - Halaman login
3. ✅ `logout.php` - Logout
4. ✅ `heartbeat.php` - Heartbeat kasir
5. ✅ `lupa_password.php` - Fitur lupa password admin
6. ✅ `reset_password.php` - Reset password via link

### **Dokumentasi Utama:**
7. ✅ `README_LUPA_PASSWORD_FINAL.md` - Panduan lengkap (PENTING!)

### **Folder:**
8. ✅ `admin/` - Folder admin
9. ✅ `kasir/` - Folder kasir
10. ✅ Folder lain yang diperlukan aplikasi

---

## 🚀 PERINTAH CLEANUP OTOMATIS:

Jalankan perintah ini di PowerShell (dari folder sim_toko2):

```powershell
# Hapus file test
if (Test-Path "test_url_dinamis.php") { Remove-Item "test_url_dinamis.php" -Force }

# Hapus dokumentasi opsional (jika tidak diperlukan)
if (Test-Path "README_HOSTING_FIX.md") { Remove-Item "README_HOSTING_FIX.md" -Force }
if (Test-Path "README_KENAPA_MASIH_LOCALHOST.md") { Remove-Item "README_KENAPA_MASIH_LOCALHOST.md" -Force }
if (Test-Path "DAFTAR_FILE_HAPUS.md") { Remove-Item "DAFTAR_FILE_HAPUS.md" -Force }

# Hapus file darurat jika ada
if (Test-Path "reset_admin_darurat.php") { Remove-Item "reset_admin_darurat.php" -Force }
if (Test-Path "reset_kasir_darurat.php") { Remove-Item "reset_kasir_darurat.php" -Force }

# Hapus file ini sendiri (terakhir)
if (Test-Path "CLEANUP_SEBELUM_HOSTING.md") { Remove-Item "CLEANUP_SEBELUM_HOSTING.md" -Force }
```

---

## 📊 STRUKTUR FOLDER MINIMAL UNTUK HOSTING:

```
sim_toko2/
├── admin/                          ← Folder admin (semua file di dalamnya)
├── kasir/                          ← Folder kasir (semua file di dalamnya)
├── koneksi.php                     ← Koneksi database
├── login.php                       ← Halaman login
├── logout.php                      ← Logout
├── heartbeat.php                   ← Heartbeat kasir
├── lupa_password.php               ← Fitur lupa password (admin)
├── reset_password.php              ← Reset password via link
└── README_LUPA_PASSWORD_FINAL.md   ← Panduan (opsional, bisa dihapus)
```

---

## ⚠️ CHECKLIST SEBELUM UPLOAD KE HOSTING:

### **1. Persiapan File:**
- [ ] File test sudah dihapus
- [ ] File darurat sudah dihapus
- [ ] Dokumentasi opsional sudah dihapus (jika tidak diperlukan)

### **2. Konfigurasi Database:**
- [ ] File `koneksi.php` sudah disesuaikan dengan database hosting
- [ ] Database sudah diimport ke hosting
- [ ] Email admin sudah diset di database hosting

### **3. Test Lokal:**
- [ ] Fitur login berfungsi
- [ ] Fitur lupa password berfungsi
- [ ] Link reset password muncul

### **4. Upload ke Hosting:**
- [ ] Semua file sudah diupload
- [ ] Folder admin/ dan kasir/ sudah diupload
- [ ] File koneksi.php sudah disesuaikan

### **5. Test di Hosting:**
- [ ] Buka website di browser
- [ ] Test login
- [ ] Test lupa password
- [ ] Pastikan link reset menggunakan domain hosting (bukan localhost)

---

## 💡 TIPS UPLOAD KE HOSTING:

### **Metode 1: FTP/SFTP (Recommended)**
1. Gunakan FileZilla atau WinSCP
2. Connect ke hosting
3. Upload semua file ke folder public_html atau htdocs
4. Pastikan struktur folder tetap sama

### **Metode 2: File Manager cPanel**
1. Login ke cPanel
2. Buka File Manager
3. Upload file satu per satu atau zip semua lalu extract

### **Metode 3: Git (Advanced)**
1. Push ke repository
2. Pull dari hosting
3. Setup auto-deployment

---

## 🔒 KEAMANAN SEBELUM HOSTING:

### **File yang HARUS Diamankan:**
1. ✅ `koneksi.php` - Jangan share password database!
2. ✅ Hapus semua file test
3. ✅ Hapus semua file darurat
4. ✅ Pastikan tidak ada password hardcoded

### **Setting Hosting:**
1. ✅ Gunakan HTTPS (SSL Certificate)
2. ✅ Set permission file yang benar (644 untuk file, 755 untuk folder)
3. ✅ Disable directory listing
4. ✅ Setup backup otomatis

---

## 🎯 LANGKAH SELANJUTNYA:

1. **Jalankan cleanup** dengan perintah di atas
2. **Cek file** yang tersisa
3. **Update koneksi.php** dengan kredensial hosting
4. **Upload ke hosting**
5. **Test semua fitur**

---

**Siap untuk hosting!** 🚀

Dibuat: 30 Januari 2026, 09:35 WIB  
Status: ✅ READY FOR CLEANUP
